/*
-------------------------------------------------------------------------------
Name:	TB_ToggleOnionLayers.js

Description: Allows the user to mass toggle on/off the background layer, which 
affects the visibility of the onion skin.

Usage:	Select panels, run script.

Author:	Corey Barnes and Karl Olson

Created: 2020/4/02

Version: 1.0.0

Feedback/Bugs contact: livingfruitvirus@gmail.com

Twitter:
Corey - http://twitter.com/myanimewaifu
Karl - http://twitter.com/karlrolson
-------------------------------------------------------------------------------
*/


function ToggleOnionLayers() { // BEGIN SCRIPT

    var selMgr = new SelectionManager();
    var layMgr = new LayerManager();
    var underLayer = new Array(0); // Array to hold the layer object
  
    var panelSel = selMgr.getPanelSelection();
    if (panelSel.length <= 0) return;
  
    // List layer names.
    var layerNames = new Array(0);
    for (var i = 0; i < panelSel.length; i++)
        {
        var panelId = panelSel[i];
        var numberOfLayers = layMgr.numberOfLayers( panelId );
 
        for ( var j = 0; j < numberOfLayers; ++j  )
            {
            var layerName = layMgr.layerName( panelId, j );
      
            if (  layerNames.indexOf(layerName) == -1 )
             layerNames.push(layerName);
 
            }
        }
    
    // Build checkbox
    var d = new Dialog();
    d.title = 'Toggle Onion Skin Layers';

    var group = new GroupBox();
    group.title = "Choose the layers you wish to toggle.";
    var count = 0;
    var checkboxArray = new Array(0);

    for (var ie = 0; ie < layerNames.length; ++ie) 
        {
        var c = new CheckBox();
        c.text = layerNames[ie];
        count++;
        checkboxArray.push(c);
        group.add(c);
        }

    d.add(group);

    var rca = d.exec();

    // If dialog cancelled, return
    if (!rca) {	
        return;
    }

    // Push the checked layers into an array.
	var layersToToggle = new Array(0);
	
	if (rca) {
		for (var f = 0; f < layerNames.length; f++) {
      			var r = checkboxArray[f];
      			if (r.checked === true) {
        			layersToToggle.push(r.text);
      			} 
    		}
  	} else {
    	return;
  	}

    // RUN SCRIPT 
    scene.beginUndoRedoAccum("Toggle Onion Layers");
    
    for (var i = 0; i < panelSel.length;i++) 
	{
      	
	var thisPanel = panelSel[i];
      
	selMgr.setCurrentPanel(thisPanel); 
      	
        for (var j = layMgr.numberOfLayers(thisPanel) - 1; j >= 0; --j) 
		{
		var selectedLayer = layMgr.layerName(thisPanel, j);
          	if (layersToToggle.indexOf(selectedLayer) !== -1)
				{
  
            		underLayer[0] = { name: selectedLayer, panelId: thisPanel };
            		selMgr.setLayerSelection(underLayer); 
  
            		Action.perform("onActionToggleOnionLayer()");
          			}
      		}
    	}
    scene.endUndoRedoAccum();
  } // END SCRIPT